 ; Ŀ
 ;   Yang - install a pipe end symbol in a circle.                         
 ;   Copyright 1995, 1996, 2010 by Rocket Software Ltd.                    
 ;   Crog's Law: 1. In order to prevent the user doing idiotic things      
 ;                  you need a program which is smarter than the user.     
 ;               2. If you have a program smarter than the user,           
 ;                  you can get rid of the user.                           
 ;               3. The program will then start doing idiotic things       
 ;                  of its own.                                            
 ; 

 ; Ŀ
 ;   Yinger - error handler.                                               
 ; 
 (DEFUN YINGER (shk)
  (setq *error* esav)
  (if cel (setvar "clayer" cel))
  (if blip (setvar "blipmode" blip))
  (if (and shk (/= shk "Function cancelled"))
      (print shk))
 (princ))
 ; Ŀ
 ;   Yinger end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Yin - draw the pipe end symbol.                            
 ;   Takes one argument, the circle ename.                                 
 ; 
 (DEFUN YIN (enam / cel entt dscale rad pa pb pc)
  (setq cel (getvar "clayer"))
  (if (tblsearch "layer" "MEDIUM")
      (setvar "clayer" "MEDIUM")
      (command "layer" "m" "medium" "c" "red" "medium" ""))
  (setq entt (entget enam))
  (setq rad (cdr (assoc 40 entt)))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dscale (misps))
      (setq dscale (getvar "dimscale")))
  (setq pa (cdr (assoc 10 entt)))
  (setq pb (polar pa (/ pi 2) rad))
  (setq pc (polar pa (* pi 1.5) rad))
  (command "pline" pc "arc" "a" "180" pa
                            "a" "-180" pb
                            "a" "180" pc "")
 ; Ŀ
 ;   Want to squash in at least 4 hatch lines (= 5 spaces).                
 ;   Line to line distance at 20 x dimscale = 2.5 x dimscale, so if the    
 ;   circle diameter < (5 x 2.5 x dimscale) then adjust the hatch scale.   
 ; 
  (if (> (* 6.25 dscale) rad)
      (setq dscale (* dscale (/ rad (* 6.25 dscale)))))
  (command "hatch" "ansi31" (* dscale 20) "0" (entlast) "")
  (setvar "clayer" cel)
 (princ))
 ; Ŀ
 ;   Yin end.                                                              
 ; 

 ; Ŀ
 ;   Yang - the other side of the coin.                                    
 ; 
 (DEFUN C:YANG (/ esav blip enam aaa aaap entt)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq esav *error*)
  (setq *error* yinger)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq enam (entsel "Circle: "))
  (cond ((null enam)
         (write-line "\nThen make a Circle: ")
         (setq aaa (entlast))
         (while (and aaa (setq aaap (entnext aaa)))
                (setq aaa aaap))
         (setvar "cmdecho" 1)
         (command "Circle")
         (while (/= (getvar "cmdactive") 0)
                (command pause))
         (setvar "cmdecho" 0)
         (if aaa
             (setq enam (entnext aaa))
             (setq enam (entlast)))
         (if (and enam (= (cdr (assoc 0 (setq entt (entget enam)))) "CIRCLE"))
             (yin enam)))
        ((and enam
              (= (cdr (assoc 0 (setq entt (entget (setq enam (car enam))))))
                                                                  "CIRCLE"))
         (yin enam))
        (T (write-line "\nWhat are trying to accomplish? ")))
  (setvar "blipmode" blip)
  (setq *error* esav)
 (princ))